//------------------------------------------------------------------------------
// File: client_inventory.cs
// This file contains the client methods for the player inventory
// Author: Matthew Rudge
//------------------------------------------------------------------------------

$INV_CLSELECTITEM = "";

////////////////////////////////////////////////////////////////////////////////
//! Returns the currently selected item id
//! \retval int Item id or ""
////////////////////////////////////////////////////////////////////////////////
function invClientGetSelectedItem()
{
   return $INV_CLSELECTITEM;
}

////////////////////////////////////////////////////////////////////////////////
//! Attempts to select an item located in the specified slot
//! \param %slot Slot that was selected
////////////////////////////////////////////////////////////////////////////////
function invClientSelectItem(%slot)
{
   // Cancel previous selection if there is one
   if($INV_CLSELECTITEM !$= "")
   {
      toolsOnCancel($INV_CLSELECTITEM);
   }
   else
   {
      %dynamiteSlot = invGetSlotForItem(ServerConnection.getId(), $INV_DYNAMITE);
      if (%slot == %dynamiteSlot)
      {
         $PLACE_DYNAMITE = true;
      }
   }
   
   commandToServer('SelectInventoryItem', %slot);
   csBeginWaitForCmd();
}

////////////////////////////////////////////////////////////////////////////////
//! Cancels the item selected
////////////////////////////////////////////////////////////////////////////////
function invCancelSelection()
{
   $PLACE_DYNAMITE = false;
   
   invClientClearSelection();
   commandToServer('UnselectInventoryItem');
}

////////////////////////////////////////////////////////////////////////////////
//! Clears the current item selection
////////////////////////////////////////////////////////////////////////////////
function invClientClearSelection()
{
   $INV_CLSELECTITEM = "";
}

//-Server Command Methods-------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
//! Creates the inventory object on the client
//! \param %slots Number of slots
////////////////////////////////////////////////////////////////////////////////
function clientCmdCreateInventory(%slots)
{
   invCreateInventory(ServerConnection.getId(), %slots);   
}

////////////////////////////////////////////////////////////////////////////////
//! Destroys the inventory object on the client
//! \param %slots Number of slots
////////////////////////////////////////////////////////////////////////////////
function clientCmdDestroyInventory()
{
   invDestroyInventory(ServerConnection.getId());
}

////////////////////////////////////////////////////////////////////////////////
//! Places an item into an inventory slot (replaces anything there)
//! \param %slot Slot for item
//! \param %item Item id
//! \param %amount Amount of items to place
//! \param %max Maximum items allowed in stack
////////////////////////////////////////////////////////////////////////////////
function clientCmdPlaceItemInInventory(%slot, %item, %amount, %max)
{
   invPlaceItem(ServerConnection.getId(), %slot, %item, %amount, %max);
}

////////////////////////////////////////////////////////////////////////////////
//! Server notification that an item has been pushed to its stack in the slot
//! \param %slot Slot of item
////////////////////////////////////////////////////////////////////////////////
function clientCmdPushItemInInventory(%slot)
{
   invPushItemOnStack(ServerConnection.getId(), %slot);
   playSFXSound(audio_itembuy);
}

////////////////////////////////////////////////////////////////////////////////
//! Server notification that an item has been popped from its stack in the slot
//! \param %slot Slot of item
////////////////////////////////////////////////////////////////////////////////
function clientCmdPopItemInInventory(%slot)
{
   invPopItemFromStack(ServerConnection.getId(), %slot);
}

////////////////////////////////////////////////////////////////////////////////
//! Server notification that an item has been selected
//! \param %item Item selected
////////////////////////////////////////////////////////////////////////////////
function clientCmdItemSelected(%item)
{   
   // Select new item
   $INV_CLSELECTITEM = %item;
   csEndWaitForCmd();
   csCmdOnButton($CSC_TOOL);
   toolsOnSelect(%item);
}
//------------------------------------------------------------------------------

// End client_inventory.cs